<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GalleryTemplateLanguage extends Model 
{

    protected $table = 'lim_gallery_template_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_gallery_template_id', 'name');
    protected $visible = array('lim_language_id', 'lim_gallery_template_id', 'name');

    public function template()
    {
        return $this->belongsTo('App\Models\GalleryTemplates', 'lim_gallery_template_id');
    }

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

}